/*****************************************************************************
*                           Freescale Semiconductor                          *
*                                                                            *
*  Project    : AN3815 - MC56F8006 Modular Pixel Matrix                      *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Authors    : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: color_manager.h                                                     *
*                                                                            *
*    Header file for color_manager.c										 * 
*                                                                            *
******************************************************************************/

/********************************* Defines ***********************************/

//! Initial Red Led Intensity.
#define CM_INIT_RED 	100
//! Initial Green Led Intensity.
#define CM_INIT_GREEN 	100
//! Initial Blue Led Intensity.
#define CM_INIT_BLUE 	100
//! Minimun LED acceptable value to avoid blinking on low intensity values.
#define CM_LED_MIN 		100
//! Number of interactions on IDLE state before controling LED intensity.
#define CM_TIMEOUT 		100
//! CM_ADC_SCALE is calculated based on ADC reading 1 Volt (1240) divided by maximum command (255).
//! 1 Volt ADC read means 200mA on the LED, the maximum allowed current. 
#define CM_ADC_SCALE 	5

/******************************** Type Definitions ***************************/
typedef enum 
{
	CM_IDLE,
	CM_ADJ_PWM,
	CM_READ_ADC,
	CM_READ_CMD
	
}CM_STATE_MACHINE;

typedef enum
{
	CM_CMD_NONE,
	CM_CMD_LIT,
	CM_CMD_STORE
	// new commands to be implemented
}CM_STATUS;

/******************************** Prototypes **********************************/
extern void colorm_init(void);
extern void colorm_task(void);
extern void colorm_rcv_value(uint8_t,uint8_t,uint8_t,CM_STATUS);


